package ru.yandex.chemodan.app.lentaloader;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.lentaloader.log.ActionSource;
import ru.yandex.chemodan.app.lentaloader.log.ActionSourceHolder;
import ru.yandex.chemodan.eventlog.log.TskvLogLine;
import ru.yandex.chemodan.http.YandexCloudRequestIdHolder;
import ru.yandex.commune.salr.logreader.LogListener;
import ru.yandex.misc.support.tl.ThreadLocalHandle;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class LentaActionSourceLogListener implements LogListener {
    private final LogListener logListener;

    public LentaActionSourceLogListener(LogListener logListener) {
        this.logListener = logListener;
    }

    @Override
    public void processLogLine(String line) {
        Option<ThreadLocalHandle> handle = TskvLogLine.parse(line)
                .getNonEmptyStringO("req_id")
                .map(YandexCloudRequestIdHolder::setAndPushToNdc);
        ActionSourceHolder.set(ActionSource.logBroker());
        try {
            logListener.processLogLine(line);
        } finally {
            ActionSourceHolder.remove();
            handle.forEach(ThreadLocalHandle::popSafely);
        }
    }
}
