package ru.yandex.chemodan.app.lentaloader;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.dataapi.web.admin.DataApiCoreAdminContextConfiguration;
import ru.yandex.chemodan.app.lentaloader.blocks.AlbumBlockManager;
import ru.yandex.chemodan.app.lentaloader.blocks.ContentBlockManager;
import ru.yandex.chemodan.app.lentaloader.blocks.FolderCreationBlockManager;
import ru.yandex.chemodan.app.lentaloader.blocks.ResourceBlockManager;
import ru.yandex.chemodan.app.lentaloader.blocks.SharedFolderBlockManager;
import ru.yandex.chemodan.app.lentaloader.reminder.PhotoReminderTaskManager;
import ru.yandex.chemodan.app.uaas.experiments.ExperimentsContextConfigutation;
import ru.yandex.chemodan.eventlog.MetricsEventLogListener;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.util.BleedingEdge;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.dynproperties.DynamicPropertiesContextConfiguration;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        DataApiCoreAdminContextConfiguration.class,
        LentaBlocksContextConfiguration.class,
        DynamicPropertiesContextConfiguration.class,
        ExperimentsContextConfigutation.class,
})
public class LentaCoreContextConfiguration {
    @Bean
    public LentaEventsLogListener lentaLogListener(
            MpfsClient mpfsClient,
            AlbumBlockManager albumBlockManager,
            ContentBlockManager contentBlockManager,
            ResourceBlockManager resourceBlockManager,
            FolderCreationBlockManager folderCreationBlockManager,
            SharedFolderBlockManager sharedFolderBlockManager,
            BleedingEdge bleedingEdge)
    {
        return new LentaEventsLogListener(
                mpfsClient, albumBlockManager,
                contentBlockManager, resourceBlockManager,
                folderCreationBlockManager, sharedFolderBlockManager,
                bleedingEdge);
    }

    @Bean
    public MetricsEventLogListener metricsEventLogListener(BazingaTaskManager bazingaTaskManager,
            PhotoReminderTaskManager photoReminderTaskManager) {
        return new LentaMetricsEventsLogListener(bazingaTaskManager, photoReminderTaskManager);
    }

    @Bean
    public BleedingEdge bleedingEdge() {
        return new BleedingEdge("lenta");
    }
}
