package ru.yandex.chemodan.app.lentaloader;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.log.DataapiLog4jHelper;
import ru.yandex.chemodan.app.lentaloader.log.LentaEventLogger;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.misc.db.monica.JdbcMetricsSwitch;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author Dmitriy Amelin
 */
public class LentaLoaderMain extends ChemodanMainSupport {
    public static void main(String[] args) {
        JdbcMetricsSwitch.ENABLED = true;
        JdbcMetricsSwitch.COMMAND_METRICS_ENABLED = true;
        new LentaLoaderMain().runMain(args);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("disk", "lenta-loader");
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(
                ChemodanCommonContextConfiguration.class,
                LentaLoaderContextConfiguration.class);
    }

    @Override
    protected void configureLogger() {

        super.configureLogger();

        DataapiLog4jHelper.configureDatabaseChangesTskvLogger(applicationName());

        Log4jHelper.appenderBuilder()
                .appName(applicationName())
                .name(LentaEventLogger.logger.logger.name)
                .postfix("-events")
                .layout(LentaEventLogger.logger.pattern)
                .async(false)
                .buffSize(1024)
                .build();

    }
}
