package ru.yandex.chemodan.app.lentaloader;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.chemodan.app.lentaloader.log.LentaEventLogger;
import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.log.mlf.Level;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.test.Assert;
import ru.yandex.misc.test.TestDirRule;
import ru.yandex.misc.version.SimpleAppName;

public class LentaLoggerTest {

    @Rule
    public final TestDirRule testDir = new TestDirRule();

    @BeforeClass
    public static void prepare() {
        Log4jHelper.initLogger(Level.INFO, Level.INFO);

    }
    @Before
    public void startAppender() {
        Log4jHelper.appenderBuilder()
                .appName(new SimpleAppName("test", "test"))
                .name(LentaEventLogger.logger.logger.name)
                .postfix("-events")
                .layout(LentaEventLogger.logger.pattern)
                .fileName(testDir.testDir + "/"  + "log.txt")
                .async(false)
                .buffSize(10)
                .build();
    }

    @Test
    public void test() {

        ru.yandex.misc.log.mlf.Logger logger = LoggerFactory.getLogger(LentaEventLogger.logger.logger.name);
        logger.info("test test");
        String content = new File2(testDir.testDir + "/"  + "log.txt").readText();
        Assert.assertContains(content, "ycrid");
    }

}
