package ru.yandex.chemodan.app.lentaloader;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.util.yt.YqlHelper;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.impl.YtUtils;

/**
 * @author messiahlap
 */
@Configuration
public class LentaYtContextConfiguration {

    @Value("${lenta-worker.yt.http.proxy}")
    private String ytHttpProxyUrl;

    @Value("${lenta-worker.java-stat.user.yt.token}")
    private String ytUserOauthToken;

    @Bean
    public Yt ytClient() {
        return YtUtils.http(ytHttpProxyUrl, ytUserOauthToken);
    }

    @Bean
    public YqlHelper yqlHelper(@Value("${yql.datasource.url}") String url,
                               @Value("${lenta-worker.yql.datasource.user}") String user,
                               @Value("${lenta-worker.java-stat.user.yt.token}") String token)
    {
        return new YqlHelper(url, token, user);
    }
}
