package ru.yandex.chemodan.app.lentaloader;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;
import ru.yandex.commune.dynproperties.DynamicPropertyWatcher;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class MetricsEventListenerCorePoolSizeConfigurer implements DynamicPropertyWatcher<Integer> {

    private static final Logger logger = LoggerFactory.getLogger(MetricsEventListenerCorePoolSizeConfigurer.class);

    private final ThreadPoolExecutor executor;

    private final DynamicProperty<Integer> metricsEventListenerCorePullSize;

    public MetricsEventListenerCorePoolSizeConfigurer(int metricsEventListenerCorePullSize, int queueCapacity) {
        this.metricsEventListenerCorePullSize = new DynamicProperty<>("cool-lenta-metrics-event-listener-max-core-pool-size",
                metricsEventListenerCorePullSize);
        int corePoolSize = this.metricsEventListenerCorePullSize.get();
        this.executor = new ThreadPoolExecutor(0, corePoolSize, 60L, TimeUnit.SECONDS,
                new LinkedBlockingQueue<>(queueCapacity), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    public void updated(Integer maxCorePoolSize) {
        logger.info("Changing metrics event listener maximum pool size to {}", maxCorePoolSize);
        executor.setMaximumPoolSize(maxCorePoolSize);
    }

    public void registerTo(DynamicPropertyManager dynamicPropertyManager) {
        dynamicPropertyManager.registerAndFireWatcher(metricsEventListenerCorePullSize, this);
    }

    public ExecutorService getExecutor() {
        return executor;
    }
}
