package ru.yandex.chemodan.app.lentaloader;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.lentaloader.worker.LentaCeleryTaskSupport;
import ru.yandex.chemodan.eventlog.celery.CeleryLogLineUtils;
import ru.yandex.chemodan.eventlog.log.TskvLogLine;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTaskParameters;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;

/**
 * @author dbrylev
 */
public class ProcessLentaLogLineCeleryTask extends LentaCeleryTaskSupport {
    private LentaEventsLogListener listener;

    public ProcessLentaLogLineCeleryTask(LentaEventsLogListener listener) {
        this.listener = listener;
    }

    public ProcessLentaLogLineCeleryTask(String logLine) {
        super(CeleryLogLineUtils.toCeleryOneTimeTaskParameters(TskvLogLine.parse(logLine)));
    }

    @Override
    protected void doExecute(CeleryOnetimeTaskParameters parameters, ExecutionContext context) throws Exception {
        listener.processLogLine(CeleryLogLineUtils.toTskvLogLine(parameters));
    }

    @Override
    public TaskId celeryTaskId() {
        return new TaskId("lenta.process_log_line");
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(2);
    }
}
