package ru.yandex.chemodan.app.lentaloader;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.lentaloader.cool.generator.ThemeDefinitionRegistry;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

@Configuration
public class ThemeRegistryContextConfiguration {

    @Bean
    public ThemeDefinitionRegistry themeDefinitionRegistry(@Qualifier("zkRoot") ZkPath zkRoot, ZkManager zkManager) {
        ThemeDefinitionRegistry themeDefinitionRegistry = new ThemeDefinitionRegistry(zkRoot.child("cool-lenta-themes"));
        zkManager.addClient(themeDefinitionRegistry);
        return themeDefinitionRegistry;
    }
}
