package ru.yandex.chemodan.app.lentaloader;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.misc.env.EnvironmentType;

/**
 * @author yashunsky
 */
public class YtPathsUtils {
    private static final String MEMORIES_PATH = "memories";
    private static final String COOL_LENTA_PATH = "cool-lenta";
    private static final String COOL_LENTA_REINDEX_QUEUE = "reindex-queue";
    private static final String COOL_LENTA_USER_WITH_BLOCKS = "user_with_blocks";
    private static final Pattern TABLE_WITH_DATE_PATTERN = Pattern.compile(".*/(?<date>\\d{4}-\\d{2}-\\d{2}).*");

    private static String addTestingFolderIfNeeded(String path) {
        return EnvironmentType.getActive() != EnvironmentType.PRODUCTION ? path + "testing/" : path;
    }

    private static String getMpfsStatsHomeFolderPath() {
        return addTestingFolderIfNeeded("//home/mpfs-stat/");
    }

    public static YPath getMemoriesYPath() {
        return YPath.simple(getMpfsStatsHomeFolderPath() + MEMORIES_PATH);
    }

    public static YPath getCoolLentaYPath() {
        return YPath.simple(getMpfsStatsHomeFolderPath() + COOL_LENTA_PATH);
    }

    public static YPath getCoolLentaReindexQueueYPath() {
        return getCoolLentaYPath().child(COOL_LENTA_REINDEX_QUEUE);
    }

    public static YPath getCoolLentaUserWithBlocksYPath() {
        return getCoolLentaYPath().child(COOL_LENTA_USER_WITH_BLOCKS);
    }

    public static Option<LocalDate> getTableDateFromPath(String path) {
        Matcher matcher = TABLE_WITH_DATE_PATTERN.matcher(path);
        if (!matcher.matches()) {
            return Option.empty();
        }
        return Option.of(LocalDate.parse(matcher.group("date"), DateTimeFormat.forPattern("yyyy-MM-dd")));
    }
}
