package ru.yandex.chemodan.app.lentaloader.blocks;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaManager;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaRecordType;
import ru.yandex.chemodan.app.lentaloader.lenta.update.LentaBlockCreateData;
import ru.yandex.chemodan.app.lentaloader.log.ActionInfo;

/**
 * @author dbrylev
 */
public class AlbumBlockManager {

    private final LentaManager lentaManager;

    public AlbumBlockManager(LentaManager lentaManager) {
        this.lentaManager = lentaManager;
    }

    public void createOwned(DataApiUserId uid, String albumId, ActionInfo actionInfo) {
        LentaBlockCreateData data = new LentaBlockCreateData(
                LentaRecordType.ALBUM_OWNED, albumId,
                Cf.toMap(Cf.list(AlbumOwnedBlockFields.ALBUM_ID.toData(albumId))));

        lentaManager.findOrCreateBlock(uid, data, actionInfo);
    }

    public void createPublic(DataApiUserId uid, String shortUrl, ActionInfo actionInfo) {
        LentaBlockCreateData data = new LentaBlockCreateData(
                LentaRecordType.ALBUM_PUBLIC, shortUrl,
                Cf.toMap(Cf.list(AlbumPublicBlockFields.SHORT_URL.toData(shortUrl))));

        lentaManager.findOrCreateBlock(uid, data, actionInfo);
    }
}
