package ru.yandex.chemodan.app.lentaloader.blocks;

import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.bolts.function.Function2;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.test.ActivateDataApiEmbeddedPg;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.test.DataApiTestSupport;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
@ActivateDataApiEmbeddedPg
public class BlockItemManagerTest extends DataApiTestSupport {

    private BlockItemManager blockItemManager;
    @Autowired
    private DataApiManager dataApiManager;

    private DataApiUserId uid;

    @Before
    public void setup() {
        uid = createRandomCleanUserInDefaultShard();
        blockItemManager = new BlockItemManager(dataApiManager);
    }

    @Test
    public void createUpdateAndDelete() {
        Function0<ListF<String>> getItemIds = () ->
                blockItemManager.getItems(uid, "block", Option.empty(), Option.empty()).map(i -> i.itemId);

        Function1V<String> createOrUpdate = itemId ->
                blockItemManager.createOrUpdateItem(uid, new BlockItemId("block", itemId), Cf.map());

        Function1V<String> delete = itemId ->
                blockItemManager.deleteItem(uid, new BlockItemId("block", itemId));

        createOrUpdate.apply("item3");
        createOrUpdate.apply("item1");
        createOrUpdate.apply("item2");

        Assert.equals(Cf.list("item2", "item1", "item3"), getItemIds.apply());

        createOrUpdate.apply("item3");
        Assert.equals(Cf.list("item3", "item2", "item1"), getItemIds.apply());

        delete.apply("item3");
        Assert.equals(Cf.list("item2", "item1"), getItemIds.apply());
    }

    @Test
    public void getItems() {
        Function2<Option<String>, Option<Integer>, ListF<String>> getItemOrders = (lastOrder, limit) ->
                blockItemManager.getItems(uid, "block", lastOrder, limit).map(i -> i.order);

        Cf.range(0, 4).forEach(num -> blockItemManager.createOrUpdateItem(
                uid, new BlockItemId("block", "item" + num), Cf.map()));

        ListF<String> orders = getItemOrders.apply(Option.empty(), Option.empty());
        Assert.hasSize(4, orders);

        Assert.equals(orders.take(1), getItemOrders.apply(Option.empty(), Option.of(1)));
        Assert.equals(orders.drop(1).take(1), getItemOrders.apply(Option.of(orders.get(0)), Option.of(1)));
        Assert.equals(orders.drop(2), getItemOrders.apply(Option.of(orders.get(1)), Option.empty()));
    }
}
