package ru.yandex.chemodan.app.lentaloader.blocks;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.support.RecordField;
import ru.yandex.chemodan.app.dataapi.support.RecordFieldUtils;

/**
 * @author dbrylev
 */
public class BlockItemRecord {
    public final String itemId;
    public final String blockId;

    public final String order;
    public final MapF<String, DataField> specific;

    public BlockItemRecord(
            String itemId, String blockId, String order,
            MapF<String, DataField> specific)
    {
        this.blockId = blockId;
        this.itemId = itemId;
        this.order = order;
        this.specific = specific.filterKeys(Fields.NAMES.containsF().notF());
    }

    public static BlockItemRecord fromDataRecord(DataRecord rec) {
        return new BlockItemRecord(
                rec.getRecordId(), rec.getCollectionId(),
                Fields.ORDER.get(rec), rec.getData());
    }

    public MapF<String, DataField> toData() {
        return Cf.toMap(Cf.list(Fields.ORDER.toData(order))).plus(specific);
    }

    public ListF<FieldChange> diffFrom(MapF<String, DataField> previous) {
        return RecordFieldUtils.diff(previous, toData());
    }

    public interface Fields {
        RecordField<String> ORDER = RecordField.string("order");

        SetF<String> NAMES = RecordFieldUtils.fieldNames(Fields.class);
    }
}
