package ru.yandex.chemodan.app.lentaloader.blocks;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author dbrylev
 */
public enum ContentBlockAction implements StringEnum {
    ADDITION("addition"),
    AUTOSAVE("autosave"),
    PHOTO_UNLIM("photounlim"),
    UPDATE("update"),
    SAVE_PUBLIC("save_public"),
    ;

    public static final StringEnumResolver<ContentBlockAction> R = StringEnumResolver.r(ContentBlockAction.class);

    private final String value;

    ContentBlockAction(String value) {
        this.value = value;
    }

    public static Option<ContentBlockAction> byEventType(EventType type) {
        switch (type) {
            case FS_COPY:
            case FS_MOVE:
            case FS_STORE:
            case FS_STORE_DOWNLOAD:
            case FS_TRASH_RESTORE:
            case SOCIAL_IMPORT:
                return Option.of(ContentBlockAction.ADDITION);

            case FS_STORE_PHOTOSTREAM:
                return Option.of(ContentBlockAction.AUTOSAVE);
            case FS_STORE_PHOTOUNLIM:
                return Option.of(ContentBlockAction.PHOTO_UNLIM);
            case FS_RENAME:
            case FS_STORE_UPDATE:
            case FS_STORE_OFFICE:
            case FS_AVIARY_RENDER:
                return Option.of(ContentBlockAction.UPDATE);
        }
        return Option.empty();
    }

    @Override
    public String value() {
        return value;
    }
}
