package ru.yandex.chemodan.app.lentaloader.blocks;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaBlockRecord;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author akirakozov
 */
public class ContentBlockMeta extends DefaultObject {
    public final String folderId;
    public final String mediaType;
    public final String modifierUid;
    public final int filesCount;
    public final Option<ContentBlockAction> action;
    public final Option<String> area;

    private ContentBlockMeta(
            String folderId, String mediaType, String modifierUid,
            int filesCount, Option<ContentBlockAction> action,
            Option<String> area)
    {
        this.folderId = folderId;
        this.mediaType = mediaType;
        this.modifierUid = modifierUid;
        this.filesCount = filesCount;
        this.action = action;
        this.area = area;
    }

    public static ContentBlockMeta fromBlock(DataApiUserId uid, LentaBlockRecord block) {
        return new ContentBlockMeta(
                ContentBlockFields.FOLDER_ID.get(block),
                ContentBlockFields.MEDIA_TYPE.get(block),
                ContentBlockFields.MODIFIER_UID.getO(block).getOrElse(uid.serialize()),
                ContentBlockFields.FILES_COUNT.get(block),
                ContentBlockFields.ACTION.getO(block),
                ContentBlockFields.AREA.getO(block));
    }
}
