package ru.yandex.chemodan.app.lentaloader.blocks;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author yashunsky
 */
public enum FolderCreationBlockAction implements StringEnum {
    SAVE_PUBLIC("save_public"),
    SAVING_PUBLIC("saving_public"),
    ;

    public static final StringEnumResolver<ContentBlockAction> R = StringEnumResolver.r(ContentBlockAction.class);

    private final String value;

    FolderCreationBlockAction(String value) {
        this.value = value;
    }

    public static Option<FolderCreationBlockAction> byEventType(EventType type) {
        // XXX until we don't have saved_from_public as a specific EventType
        return Option.empty();
    }

    @Override
    public String value() {
        return value;
    }
}
