package ru.yandex.chemodan.app.lentaloader.blocks;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.support.I18nValue;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaRecordType;
import ru.yandex.chemodan.app.lentaloader.lenta.update.CreateHandler;
import ru.yandex.chemodan.app.lentaloader.lenta.update.LentaBlockBaseData;
import ru.yandex.chemodan.app.lentaloader.lenta.update.LentaBlockCreateData;

/**
 * @author dbrylev
 */
public class GenericBlockData {
    public final String groupKey;

    public final I18nValue<String> title;
    public final I18nValue<String> text;
    public final I18nValue<String> icon;
    public final I18nValue<String> picture;

    public final MapF<String, DataField> specific;

    public GenericBlockData(
            String groupKey,
            I18nValue<String> title,
            I18nValue<String> text,
            I18nValue<String> icon,
            I18nValue<String> picture,
            MapF<String, DataField> specific)
    {
        this.groupKey = groupKey;
        this.title = title;
        this.text = text;
        this.icon = icon;
        this.picture = picture;
        this.specific = specific;
    }

    public LentaBlockCreateData asCreateData() {
        return new LentaBlockCreateData(getBaseData(), rec -> CreateHandler.create(getSpecificData()));
    }

    public LentaBlockBaseData getBaseData() {
        return new LentaBlockBaseData(LentaRecordType.GENERIC_BLOCK, groupKey);
    }

    public MapF<String, DataField> getSpecificData() {
        return specific.plus(Cf.toMap(Cf.list(
                GenericBlockFields.TITLE.toData(title),
                GenericBlockFields.TEXT.toData(text),
                GenericBlockFields.ICON.toData(icon),
                GenericBlockFields.PICTURE.toData(picture)).flatMap(l -> l)));
    }
}
