package ru.yandex.chemodan.app.lentaloader.blocks;

import ru.yandex.chemodan.eventlog.events.MpfsAddress;
import ru.yandex.chemodan.eventlog.events.Resource;
import ru.yandex.chemodan.mpfs.MpfsResourceId;
import ru.yandex.chemodan.mpfs.MpfsUid;

/**
 * @author dbrylev
 */
public class ModifiedResource {
    public final Resource resource;
    public final MpfsAddress address;
    public final MpfsResourceId folderId;
    public final MpfsUid modifier;
    public final MpfsUid owner;

    public ModifiedResource(
            Resource resource, MpfsAddress address,
            MpfsResourceId folderId, MpfsUid modifier, MpfsUid owner)
    {
        this.resource = resource;
        this.address = address;
        this.folderId = folderId;
        this.modifier = modifier;
        this.owner = owner;
    }

    public String mediaType() {
        return resource.compoundType.mediaTypeValueOrUnknown();
    }

    public String fileId() {
        return resource.fileId;
    }
}
