package ru.yandex.chemodan.app.lentaloader.blocks;

import java.net.URL;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.eventlog.events.CompoundResourceType;
import ru.yandex.chemodan.eventlog.events.Resource;
import ru.yandex.chemodan.eventlog.events.ResourceType;
import ru.yandex.chemodan.mpfs.MpfsResourceId;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author dbrylev
 */
public class OwnedOrPublishedResource {
    public final Either<MpfsResourceId, String> idOrUrl;
    public final CompoundResourceType type;

    public OwnedOrPublishedResource(Either<MpfsResourceId, String> idOrUrl, CompoundResourceType type) {
        this.idOrUrl = Either.fromOptions(idOrUrl.leftO(), idOrUrl.rightO().map(OwnedOrPublishedResource::unifiedUrl));
        this.type = type;
    }

    public static OwnedOrPublishedResource owned(MpfsResourceId resourceId, CompoundResourceType type) {
        return new OwnedOrPublishedResource(Either.left(resourceId), type);
    }

    public static OwnedOrPublishedResource owned(Resource resource) {
        return owned(new MpfsResourceId(resource.owner, resource.fileId), resource.compoundType);
    }

    public static OwnedOrPublishedResource published(String shortUrl, CompoundResourceType type) {
        return new OwnedOrPublishedResource(Either.right(shortUrl), type);
    }

    public boolean isOwned() {
        return idOrUrl.isLeft();
    }

    private static final Pattern2 albumUrlPattern = Pattern2.compile("^[^:]+://[^/]+/a/.+$");

    public boolean isAlbum() {
        return type.type == ResourceType.ALBUM || idOrUrl.isRight() && albumUrlPattern.matches(idOrUrl.getRight());
    }

    static String unifiedUrl(String url) {
        try {
            URL parsed = UrlUtils.url(url);

            Option<String> hash = UrlUtils.getQueryParameterFromUrl(url, "hash");

            url = parsed.getHost().equals("public.dsp.yadi.sk")
                    ? "http://yadi.sk" + parsed.getPath()
                    : "http://" + parsed.getHost() + parsed.getPath();

            return hash.isPresent() ? UrlUtils.addParameter(url, "hash", hash.get()) : url;

        } catch (RuntimeException e) {
            return url;
        }
    }
}
