package ru.yandex.chemodan.app.lentaloader.blocks;

import org.junit.Test;

import ru.yandex.bolts.function.Function1B;
import ru.yandex.chemodan.eventlog.events.CompoundResourceType;
import ru.yandex.misc.test.Assert;

import static ru.yandex.chemodan.app.lentaloader.blocks.OwnedOrPublishedResource.unifiedUrl;

/**
 * @author dbrylev
 */
public class OwnedOrPublishedResourceTest {

    @Test
    public void urlUnified() {
        Assert.equals("http://yadi.sk/d/aPqJNaOwuQ56", unifiedUrl("https://yadi.sk:443/d/aPqJNaOwuQ56?touch=no#hash"));
        Assert.equals("абвгдика", unifiedUrl("абвгдика"));
    }

    @Test
    public void hashParameter() {
        Assert.equals("http://disk3.dsp.yandex.ru/public/nda/?hash=E26Mqxa4RehcxA5Llx5UQ%3D",
                unifiedUrl("https://disk3.dsp.yandex.ru/public/nda/?hash=E26Mqxa4RehcxA5Llx5UQ%3D"));
    }

    @Test
    public void albumByUrl() {
        Function1B<String> isAlbum = url -> OwnedOrPublishedResource.published(
                url, CompoundResourceType.file("unknown")).isAlbum();

        Assert.isTrue(isAlbum.apply("http://public.dst.yadi.sk/a/3d4RgFe7ZHeW"));
        Assert.isTrue(isAlbum.apply("http://yadi.sk/a/JumFu-UIwUoJC"));

        Assert.isTrue(isAlbum.apply("https://yadi.sk:443/a/aPqJNaOwuQ56?touch=no#hash"));
        Assert.isFalse(isAlbum.apply("http://yadi.sk/d/aPqJNaOwuQ56"));
    }
}
