package ru.yandex.chemodan.app.lentaloader.blocks;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author dbrylev
 */
public enum PublicResourceAction implements StringEnum {
    VISIT("visit"),
    COMMENT("comment"),
    LIKE("like"),
    DISLIKE("dislike"),
    ;

    public static final StringEnumResolver<PublicResourceAction> R = StringEnumResolver.r(PublicResourceAction.class);

    private final String value;

    PublicResourceAction(String value) {
        this.value = value;
    }

    public static Option<PublicResourceAction> byEventType(EventType eventType) {
        switch (eventType) {
            case PUBLIC_VISIT: return Option.of(VISIT);
            case COMMENT_ADD: return Option.of(COMMENT);
            case COMMENT_LIKE_ADD: return Option.of(LIKE);
            case COMMENT_DISLIKE_ADD: return Option.of(DISLIKE);
        }
        return Option.empty();
    }

    public boolean isCancelledBy(EventType eventType) {
        switch (eventType) {
            case COMMENT_DELETE: return this == COMMENT;
            case COMMENT_LIKE_DELETE: return this == LIKE;
            case COMMENT_DISLIKE_DELETE: return this == DISLIKE;
        }
        return false;
    }

    @Override
    public String value() {
        return value;
    }
}
