package ru.yandex.chemodan.app.lentaloader.blocks;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.eventlog.events.sharing.ShareEventType;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author dbrylev
 */
public enum SharedFolderAction implements StringEnum {
    CHANGE("change"),
    ACCEPT("accept"),
    DECLINE("decline"),
    ;

    public static final StringEnumResolver<SharedFolderAction> R = StringEnumResolver.r(SharedFolderAction.class);

    private final String value;

    SharedFolderAction(String value) {
        this.value = value;
    }

    public static Option<SharedFolderAction> byEventType(ShareEventType eventType) {
        switch (eventType) {
            case INVITE_USER:
            case REMOVE_INVITE:
            case CHANGE_INVITE_RIGHTS:
            case CHANGE_RIGHTS:
            case KICK_FROM_GROUP:
            case LEAVE_GROUP:
                return Option.of(SharedFolderAction.CHANGE);
            case ACTIVATE_INVITE:
                return Option.of(SharedFolderAction.ACCEPT);
            case REJECT_INVITE:
                return Option.of(SharedFolderAction.DECLINE);
        }
        return Option.empty();
    }

    @Override
    public String value() {
        return value;
    }
}
