package ru.yandex.chemodan.app.lentaloader.cool;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.dynproperties.DynamicProperty;

/**
 * @author messiahlap
 */
public class CoolLentaConfigurationManager {

    public static final String DESKTOP = "desktop";

    public final DynamicProperty<ListF<String>> platformsToPush = new DynamicProperty<>("cool-lenta-default-platforms", Cf.list("android", "ios"));

    private final DynamicProperty<Boolean> pushesToGncAreEnabled = new DynamicProperty<>("cool-lenta-pushes-to-gnc-enabled", false);

    public final DynamicProperty<Integer> maxMordaBlocksCount = new DynamicProperty<>("cool-lenta-max-morda-blocks-count", 10);

    private final DynamicProperty<String> pushUrlPrefix = new DynamicProperty<>("morda-push-url-prefix", "https://disk.yandex.ru/client/remember/");

    public String getBaseMordaBlockLink(String mordaBlockId) {
        return pushUrlPrefix.get() + mordaBlockId;
    }

    public boolean isGncPushesEnabled() {
        return pushesToGncAreEnabled.get();
    }

}
