package ru.yandex.chemodan.app.lentaloader.cool;

import java.util.List;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.lentaloader.ThemeRegistryContextConfiguration;
import ru.yandex.chemodan.app.lentaloader.cool.generator.CoolLentaBlockGenerator;
import ru.yandex.chemodan.app.lentaloader.cool.generator.CoolLentaBlockGeneratorsContextConfiguration;
import ru.yandex.chemodan.app.lentaloader.cool.imageparser.ImageparserClient;
import ru.yandex.chemodan.app.lentaloader.cool.imageparser.ImageparserContextConfiguration;
import ru.yandex.chemodan.app.lentaloader.reminder.Cvi2tProcessor;
import ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchClient;
import ru.yandex.chemodan.app.uaas.experiments.ExperimentsManager;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.ratelimiter.ClusteredRpsLimiter;
import ru.yandex.chemodan.util.blackbox.UserTimezoneHelper;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;
import ru.yandex.inside.geobase.Geobase6;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.misc.io.file.File2;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        CoolLentaBlockGeneratorsContextConfiguration.class,
        ImageparserContextConfiguration.class,
        ThemeRegistryContextConfiguration.class
})
public class CoolLentaCoreContextConfiguration {
    @Autowired
    private DynamicPropertyManager dynamicPropertyManager;

    @Bean
    @Qualifier("sup")
    @OverridableValuePrefix("sup")
    public HttpClientConfigurator supHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    @Qualifier("blackbox")
    @OverridableValuePrefix("blackbox")
    public HttpClientConfigurator blackboxHttpClientConfigurator(){
        return new HttpClientConfigurator();
    }

    @Bean
    public SupClient supClient(@Value("${sup.api.url}") String apiUrl, @Value("${sup.oauth.token}") String token,
            @Qualifier("sup") HttpClientConfigurator configurator)
    {
        return new SupClient(apiUrl, token, configurator.configure());
    }

    @Bean
    public MordaPushManager mordaPushManager(Blackbox2 blackbox, SupClient supClient, MpfsClient mpfsClient,
            DataApiManager dataApiManager, UserTimezoneHelper tzHelper, CoolLentaConfigurationManager coolLentaConfigurationManager)
    {
        return new MordaPushManager(blackbox, supClient, mpfsClient, dataApiManager, tzHelper, coolLentaConfigurationManager);
    }

    @Bean
    public CoolLentaManager coolLentaManager(DiskSearchClient searchClient, List<CoolLentaBlockGenerator> blockGenerators,
            MpfsClient mpfsClient, UserTimezoneHelper userTimezoneHelper, DataApiManager dataApiManager,
            ImageparserClient imageparserClient, BazingaTaskManager bazingaTaskManager,
            @Value("${cool-lenta.block.repeat_timeout}") Duration minRepeatDuration,
            @Value("${lenta.block-previews.max-age}") Duration maxLastBlockAge, Geobase6 geobase6,
            MordaPushManager mordaPushManager, Cvi2tProcessor cvi2tProcessor, CoolLentaConfigurationManager coolLentaConfigurationManager,
            ExperimentsManager experimentsManager)
    {
        MpfsClient limitedMpfsCLient = mpfsRpsLimiter().wrapLimited(mpfsClient, MpfsClient.class);
        return new CoolLentaManager(searchClient, imageparserClient, Option.ofNullable(geobase6), limitedMpfsCLient,
                userTimezoneHelper, Cf.x(blockGenerators), dataApiManager, bazingaTaskManager, minRepeatDuration,
                maxLastBlockAge, mordaPushManager, cvi2tProcessor, coolLentaConfigurationManager, experimentsManager);
    }

    @Bean
    public Geobase6 geobase6(
            @Value("${geobase.binary.path:-/var/cache/geobase/geodata6.bin}")
            String geodataBinary,
            @Value("${geobase.enabled:-true}")
            boolean geobaseEnabled)
    {
        if (! geobaseEnabled || !new File2(geodataBinary).exists()) {
            return null;
        }
        return new Geobase6(geodataBinary);
    }

    @Bean
    public ClusteredRpsLimiter mpfsRpsLimiter() {
        return new ClusteredRpsLimiter("cool-lenta-mpfs", 1000, dynamicPropertyManager);
    }
}
