package ru.yandex.chemodan.app.lentaloader.cool;

import lombok.Data;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchFileInfo;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
@Data
@BenderBindAllFields
public class CoolLentaFileItem implements HasEtimeAndBeauty {
    public final PassportUid uid;
    public final DiskSearchFileInfo searchFileInfo;

    public final Option<Double> oldBeauty;
    public final Option<Double> newBeauty;

    public final DateTime userEtime;

    // dynamic part - can be set while processing and checking
    public Option<MpfsFileInfo> mpfsFileInfo = Option.empty();

    private CoolLentaFileItem(PassportUid uid, DiskSearchFileInfo searchFileInfo, Option<MpfsFileInfo> mpfsFileInfo,
            Option<Double> oldBeauty, Option<Double> newBeauty, DateTime userEtime)
    {
        this.uid = uid;
        this.searchFileInfo = searchFileInfo;
        this.oldBeauty = oldBeauty;
        this.newBeauty = newBeauty;
        this.userEtime = userEtime;
        this.mpfsFileInfo = mpfsFileInfo;
    }

    public CoolLentaFileItem(PassportUid uid, DateTimeZone userTimezone, DiskSearchFileInfo info) {
        this(uid, userTimezone, info, null);
    }

    public CoolLentaFileItem(PassportUid uid, DateTimeZone userTimezone, DiskSearchFileInfo info,
            MpfsFileInfo mpfsInfo)
    {
        this(uid, info, Option.ofNullable(mpfsInfo), info.beautiful, info.beautiful2,
                new DateTime(info.etime.get() * 1000, userTimezone));
    }
}
