package ru.yandex.chemodan.app.lentaloader.cool;

import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.uaas.zk.ExperimentOverride;
import ru.yandex.chemodan.app.uaas.zk.UaasOverrideController;
import ru.yandex.chemodan.app.uaas.zk.UserGroupsZkRegistry;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.parse.BenderParser;

public class ExperimentMembersByOverrideManager {

    private static final BenderParser<OverrideData> OVERRIDE_DATA_BENDER_PARSER = Bender.parser(OverrideData.class);

    private final UaasOverrideController uaasOverrideController;

    private final UserGroupsZkRegistry groupsZkRegistry;

    public ExperimentMembersByOverrideManager(UaasOverrideController uaasOverrideController,
            UserGroupsZkRegistry groupsZkRegistry)
    {
        this.uaasOverrideController = uaasOverrideController;
        this.groupsZkRegistry = groupsZkRegistry;
    }

    public boolean isExperimentMember(PassportUid uid, String experiment) {
        return uaasOverrideController.find(Option.of(uid.toUidOrZero().getUid()), Option.empty())
                .map(ExperimentOverride::getOverrideJson).map(OVERRIDE_DATA_BENDER_PARSER::parseJson)
                .exists(overrideData -> overrideData.getContext().flatMapO(Context::getDisk).map(DiskContext::getFlags)
                        .getOrElse(Cf::list).containsTs(experiment));
    }

    public ListF<Long> getMembers(String experimentId) {
        return uaasOverrideController.getAll()
                .filter(experimentOverride -> OVERRIDE_DATA_BENDER_PARSER.parseJson(experimentOverride.getOverrideJson())
                        .getContext().flatMapO(Context::getDisk).map(DiskContext::getFlags).getOrElse(Cf::list)
                        .containsTs(experimentId))
                .flatMap(this::getMembers);
    }

    private ListF<Long> getMembers(ExperimentOverride experimentOverride) {
        return Cf.toHashSet(experimentOverride.getUids().flatMap(this::parseValue)).toList();
    }

    private ListF<Long> parseValue(String value) {
        Option<Long> uidO = Cf.Long.parseSafe(value);
        if (uidO.isPresent()) {
            return Cf.list(uidO.get());
        }
        return groupsZkRegistry.getO(value).map(userGroup -> userGroup.getUids().map(Cf.Long::parseSafe).filter(Option::isPresent)
                .map(Option::get).toList()).getOrElse(Cf::list);
    }

    @Data
    @BenderBindAllFields
    private static class OverrideData {

        @BenderPart(name = "HANDLER", strictName = true)
        private final Option<String> handler;

        @BenderPart(name = "CONTEXT", strictName = true)
        private final Option<Context> context;
    }

    @Data
    @BenderBindAllFields
    private static class Context {
        @BenderPart(name = "DISK", strictName = true)
        private final Option<DiskContext> disk;
    }

    @Data
    @BenderBindAllFields
    private static class DiskContext {
        private final ListF<String> flags;
    }
}
