package ru.yandex.chemodan.app.lentaloader.cool;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.uaas.zk.ExperimentOverride;
import ru.yandex.chemodan.app.uaas.zk.UaasOverrideController;
import ru.yandex.chemodan.app.uaas.zk.UserGroupsZkRegistry;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

/**
 * @author messiahlap
 */
public class ExperimentMembersByOverrideManagerTest {

    private static final String EXPERIMENT_NAME = "disk_experiment_override";

    private static final String TEST_GROUP = "test_group";

    private static final ListF<String> OVERRIDE_UIDS = Cf.list("1", "2", TEST_GROUP);

    private static final SetF<String> GROUP_UIDS = Cf.set("2", "3", "device");

    private ExperimentMembersByOverrideManager experimentMembersByOverrideManager;

    @Before
    public void initMocks() {
        UaasOverrideController uaasOverrideController = mock(UaasOverrideController.class);
        ExperimentOverride override = new ExperimentOverride(EXPERIMENT_NAME, OVERRIDE_UIDS,
                Cf.list(), "{\n" +
                "  \"HANDLER\": \"DISK\", \n" +
                "  \"CONTEXT\": {\n" +
                "     \"DISK\": {\n" +
                "      \"flags\": [\n" +
                "       \"" + EXPERIMENT_NAME + "\"\n" +
                "      ], \n" +
                "      \"testid\": [\n" +
                "      ]\n" +
                "    }\n" +
                "  }\n" +
                "}", Option.empty());
        when(uaasOverrideController.getAll()).thenReturn(Cf.list(override));
        UserGroupsZkRegistry userGroupsZkRegistry = mock(UserGroupsZkRegistry.class);
        when(userGroupsZkRegistry.getO(TEST_GROUP)).thenReturn(Option.of(new UserGroupsZkRegistry.UserGroup(TEST_GROUP, GROUP_UIDS, "")));
        experimentMembersByOverrideManager = new ExperimentMembersByOverrideManager(uaasOverrideController, userGroupsZkRegistry);
    }

    @Test
    public void testGetMembers() {
        ListF<Long> members = experimentMembersByOverrideManager.getMembers(EXPERIMENT_NAME);
        assertNotNull(members);
        assertFalse(members.isEmpty());
        assertEquals(3, members.size());
        assertTrue(members.containsTs(1L));
        assertTrue(members.containsTs(2L));
        assertTrue(members.containsTs(3L));
    }
}
