package ru.yandex.chemodan.app.lentaloader.cool;

import org.jetbrains.annotations.NotNull;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.mpfs.MpfsResourceId;

/**
 * @author tolmalev
 */
public class InconsistentCoolLentaBlockException extends RuntimeException {
    public InconsistentCoolLentaBlockException(ListF<MpfsResourceId> notFoundInMpfs, ListF<MpfsResourceId> notFoundInSearch) {
        super(buildMessage(notFoundInMpfs, notFoundInSearch));
    }

    public InconsistentCoolLentaBlockException(String message) {
        super(message);
    }

    @NotNull
    private static String buildMessage(ListF<MpfsResourceId> notFoundInMpfs, ListF<MpfsResourceId> notFoundInSearch) {
        String message = "";

        if (notFoundInMpfs.isNotEmpty()) {
            message += "Not found in mpfs: " + notFoundInMpfs.mkString("[", ", ", "]. ");
        }
        if (notFoundInSearch.isNotEmpty()) {
            message += "Not found in search: " + notFoundInMpfs.mkString("[", ", ", "]. ");
        }
        return message;
    }
}
