package ru.yandex.chemodan.app.lentaloader.cool;

import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.lentaloader.cool.model.CoolLentaBlock;
import ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchResponse;
import ru.yandex.misc.db.embedded.sandbox.SandBoxResourceRule;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

public class RandomBlocksTest extends AbstractCoolLentaManagerTest {

    @ClassRule
    public static final SandBoxResourceRule resourceRule =
            createSandboxResourceRule("1055604097");

    private static DiskSearchResponse TEST_DATA;

    private static final int COUNT = 10;

    @BeforeClass
    public static void init() {
        TEST_DATA = parseTestData(resourceRule);
    }

    @Test
    public void testGenerating() {
        CoolLentaBlock block = getManager().createRandomBlockForUser(getUid(), COUNT, DateTime.now());
        assertNotNull(block);
        ListF<CoolLentaFileItem> items = block.getItems();
        assertFalse(items.isEmpty());
        assertTrue(items.isSortedBy(CoolLentaFileItem::getUserEtime));
        assertTrue(block.getId().startsWith("random"));
    }

    @Override
    protected DiskSearchResponse getTestData() {
        return TEST_DATA;
    }
}
