package ru.yandex.chemodan.app.lentaloader.cool;

import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.lentaloader.cool.generator.WordMatch;
import ru.yandex.chemodan.app.lentaloader.cool.model.CoolLentaBlock;
import ru.yandex.chemodan.app.lentaloader.cool.utils.IntervalType;
import ru.yandex.chemodan.app.lentaloader.reminder.Cvi2tProcessor;
import ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchResponse;
import ru.yandex.misc.db.embedded.sandbox.SandBoxResourceRule;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

public class StopWordsFilteringTest extends AbstractCoolLentaManagerTest {

    @ClassRule
    public static final SandBoxResourceRule resourceRule =
            createSandboxResourceRule("1055609325");

    private static final DateTime START_TIME_INTERVAL = new DateTime(2016, 5, 20, 11, 13, 20);
    private static final DateTime END_TIME_INTERVAL = new DateTime(2019, 7, 30, 10, 36, 40);

    private static DiskSearchResponse TEST_DATA;

    @BeforeClass
    public static void init() {
        TEST_DATA = parseTestData(resourceRule);
    }

    @Test
    public void testStopWordFiltering() {
        CoolLentaManager manager = createManager(false, true);
        ListF<WordMatch> stopWords = manager.getStopWords();
        assertNotNull(stopWords);
        assertEquals(1, stopWords.size());
        WordMatch stopWord = stopWords.first();
        assertEquals(STOP_WORD, stopWord.getWord());
        assertEquals(STOP_WORD_SIMILARITY_THRESHOLD, stopWord.getSimilarityThreshold());
        ListF<CoolLentaBlock> blocks = manager
                .generateAllBlocks(getUid(), START_TIME_INTERVAL, END_TIME_INTERVAL,
                        manager.getActualBlockGenerators(IntervalType.WEEK, getUid().getUid()));
        assertNotNull(blocks);
        blocks.map(CoolLentaBlock::getItems).forEach(items -> checkFilteredItems(items, manager));
    }

    @Test
    public void testDisabledStopWordFiltering() {
        CoolLentaManager manager = getManager();
        ListF<CoolLentaBlock> blocks = manager
                .generateAllBlocks(getUid(), START_TIME_INTERVAL, END_TIME_INTERVAL,
                        manager.getActualBlockGenerators(IntervalType.WEEK, getUid().getUid()));
        assertNotNull(blocks);
        assertTrue(blocks.map(CoolLentaBlock::getItems).exists(this::hasStopWordSimilarity));
    }

    @Override
    protected DiskSearchResponse getTestData() {
        return TEST_DATA;
    }

    private boolean hasStopWordSimilarity(ListF<CoolLentaFileItem> items) {
        return items.exists(item -> getManager().getStopWords().exists(stopWord ->
                Cvi2tProcessor.dotProduct(item.getSearchFileInfo().geti2tVector(),
                        getCvi2tProcessor().getTextVector(stopWord.getWord())) > stopWord.getSimilarityThreshold()));
    }

    private void checkFilteredItems(ListF<CoolLentaFileItem> items, CoolLentaManager manager) {
        assertNotNull(items);
        assertFalse(items.isEmpty());
        assertFalse(items.exists(item -> manager.getStopWords().exists(stopWord ->
                Cvi2tProcessor.dotProduct(item.getSearchFileInfo().geti2tVector(),
                        getCvi2tProcessor().getTextVector(stopWord.getWord())) > stopWord.getSimilarityThreshold())));
    }
}
