package ru.yandex.chemodan.app.lentaloader.cool;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.Supplier;

import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.io.http.HttpException;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

@RequiredArgsConstructor
public class SupClient {

    private static final Logger logger = LoggerFactory.getLogger(SupClient.class);

    private final String apiUrl;
    private final String supOauthToken;
    private final HttpClient httpClient;

    public void sendPush(String json) {
        logger.info("SUP send push request : {}", json);
        doSupAction(getHttpRequestWithPayload(() -> new HttpPost(apiUrl), json), Cf.map());
    }

    public void deletePush(String json) {
        logger.info("SUP delete push request : {}",json);
        doSupAction(getHttpRequestWithPayload(() -> new HttpDeleteWithPayload(apiUrl), json),
                Cf.map(HttpStatus.SC_404_NOT_FOUND,
                        content -> logger.debug("Cannot delete the SUP push because it has not been found. Content: {}", content)));
    }

    private <T extends HttpEntityEnclosingRequestBase> T getHttpRequestWithPayload(Supplier<T> requestProvider, String jsonPayload) {
        T request = requestProvider.get();
        request.setHeader("Content-Type", "application/json;charset=UTF-8");
        request.setHeader("Authorization", "OAuth " + supOauthToken);
        request.setEntity(new ByteArrayEntity(jsonPayload.getBytes(StandardCharsets.UTF_8)));
        return request;
    }

    @SneakyThrows
    private void doSupAction(HttpUriRequest request, MapF<Integer, Consumer<String>> handlersForStatusCodes) {
        httpClient.execute(request, r -> {
            String content = r.getEntity() == null ? "<no content>" : IOUtils.toString(r.getEntity().getContent(), StandardCharsets.UTF_8);
            int statusCode = r.getStatusLine().getStatusCode();
            if (HttpStatus.is2xx(statusCode)) {
                logger.info(content);
                return null;
            }
            Option<Consumer<String>> handlerO = handlersForStatusCodes.getO(statusCode);
            if (!handlerO.isPresent()) {
                throw new HttpException(statusCode, content);
            }
            handlerO.get().accept(content);
            return null;
        });
    }

    // Normal HttpDelete must not have the payload but SUP expects the HTTP DELETE requests with payload for deleting notifications in GNC (Bell)
    private static class HttpDeleteWithPayload extends HttpPost {

        public HttpDeleteWithPayload(String url) {
            super(url);
        }

        @Override
        public String getMethod() {
            return "DELETE";
        }
    }
}
