package ru.yandex.chemodan.app.lentaloader.cool.generator;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.lentaloader.cool.CoolLentaFileItem;
import ru.yandex.chemodan.app.lentaloader.cool.utils.IntervalType;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author tolmalev
 */
public class BestOfYearBlockGenerator extends BlockGeneratorBase {
    private static final Logger logger = LoggerFactory.getLogger(BestOfYearBlockGenerator.class);

    private final DynamicProperty<Integer> minCount = new DynamicProperty<>("best-of-year-min-count", 5);
    private final DynamicProperty<Integer> maxCount = new DynamicProperty<>("best-of-year-max-count", 50);

    @Override
    public String generatorIdPrefix() {
        return "year_best";
    }

    @Override
    public boolean isAcceptableIntervalType(IntervalType intervalType) {
        return IntervalType.YEAR == intervalType;
    }

    @Override
    public ListF<BlockGeneratingResult> generateBlocksWithoutIntervalCheck(ListF<CoolLentaFileItem> items,
            Option<PassportUid> uid)
    {
        items = BlockGeneratorUtils.smartJoinGroups(items, maxCount.get());
        if (items.size() < minCount.get()) {
            return Cf.list();
        }

        if (items.size() > maxCount.get()) {
            items = BlockGeneratorUtils.selectBest(items, maxCount.get(), BeautySelectorType.BOTH);
        }

        IntervalType intervalType = BlockGeneratorUtils.getInterval(items)._1;
        if (intervalType != IntervalType.YEAR) {
            logger.debug("Skip year block, because  type={}", intervalType);
            return Cf.list();
        }

        return Cf.list(new BlockGeneratingResult(Option.empty(), BlockGeneratorUtils.sortByEtime(items)));
    }


}
