package ru.yandex.chemodan.app.lentaloader.cool.generator;

import org.joda.time.DateTime;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.lentaloader.cool.CoolLentaFileItem;
import ru.yandex.chemodan.app.lentaloader.cool.utils.IntervalType;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author tolmalev
 */
public abstract class BlockGeneratorBase extends AbstractCoolLentaBlockGenerator {
    private final DynamicProperty<Integer> minCount = new DynamicProperty<>("cool-lenta-min-count", 5);
    private final DynamicProperty<Integer> maxCount = new DynamicProperty<>("cool-lenta-max-count", 20);

    @Override
    public ListF<BlockGeneratingResult> generateBlocksWithoutIntervalCheck(ListF<CoolLentaFileItem> items,
            Option<PassportUid> uidO)
    {
        int minCount = this.minCount.get();
        int maxCount = this.maxCount.get();

        return generateBlockBase(items, minCount, maxCount);
    }

    protected ListF<BlockGeneratingResult> generateBlockBase(ListF<CoolLentaFileItem> items, int minCount,
            int maxCount)
    {
        items = BlockGeneratorUtils.filterByNearGroups(items, getJoinIntervalSeconds());
        if (items.length() < minCount) {
            return Cf.list();
        }
        ListF<CoolLentaFileItem> photos = BlockGeneratorUtils.selectBest(items, maxCount, BeautySelectorType.BOTH);
        photos = BlockGeneratorUtils.sortByEtime(photos);
        return Cf.list(new BlockGeneratingResult(Option.empty(), photos));
    }

    @Override
    public ListF<String> generateAllPossibleIds(IntervalType intervalType, DateTime intervalStart) {
        return Cf.list(generateBlockId(intervalType, intervalStart, Option.empty()));
    }

    @Override
    public int getMinSizeForBlock() {
        return minCount.get();
    }
}
