package ru.yandex.chemodan.app.lentaloader.cool.generator;

import javax.annotation.Nonnull;

import org.joda.time.DateTime;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.lentaloader.cool.CoolLentaFileItem;
import ru.yandex.chemodan.app.lentaloader.cool.utils.IntervalType;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author tolmalev
 */
public interface CoolLentaBlockGenerator {

    String BLOCK_ID_SEPARATOR = "_";

    String generatorIdPrefix();

    boolean isAcceptableIntervalType(IntervalType intervalType);

    ListF<BlockGeneratingResult> generateBlocksWithoutIntervalCheck(ListF<CoolLentaFileItem> items, Option<PassportUid> uidO);

    default ListF<BlockGeneratingResult> generateBlocks(ListF<CoolLentaFileItem> items, Option<PassportUid> uidO) {
        return generateBlocksWithoutIntervalCheck(
                items.filter(item -> item.getNewBeauty().filter(beauty -> beauty > getBeautyLimit()).isPresent()),
                uidO
        ).filter(result -> isAcceptableIntervalType(BlockGeneratorUtils.getInterval(result.getItems())._1));
    }

    ListF<String> generateAllPossibleIds(IntervalType intervalType, DateTime intervalStart);

    /**
     *
     * @param intervalType
     * @param intervalStart
     * @param postfix
     * @return A string in format {generator_type}_{interval_type}_{interval_start}_{postfix:optional}
     */
    @Nonnull
    default String generateBlockId(IntervalType intervalType, DateTime intervalStart, Option<String> postfix) {
        return Cf.list(generatorIdPrefix(), intervalType.toBlockIdPart(),
                String.valueOf(intervalStart.toInstant().getMillis()), postfix.getOrElse(""))
                .filter(StringUtils::isNotBlank).mkString(BLOCK_ID_SEPARATOR);
    }

    default String getGenerationType(IntervalType intervalType) {
        return generatorIdPrefix() + BLOCK_ID_SEPARATOR + intervalType;
    }

    default boolean isEnableForUid(long uid) {
        return true;
    }

    int getMinSizeForBlock();

    double getBeautyLimit();
}
