package ru.yandex.chemodan.app.lentaloader.cool.generator;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.lentaloader.cool.ExperimentMembersByOverrideManager;
import ru.yandex.chemodan.app.lentaloader.cool.utils.BlockTitlesGenerator;
import ru.yandex.chemodan.app.lentaloader.cool.utils.GeoNamesSource;
import ru.yandex.chemodan.app.lentaloader.cool.utils.TankerTextGenerator;
import ru.yandex.chemodan.app.lentaloader.cool.utils.TextProcessor;
import ru.yandex.chemodan.app.lentaloader.reminder.Cvi2tProcessor;
import ru.yandex.chemodan.app.uaas.zk.UaasOverrideController;
import ru.yandex.chemodan.app.uaas.zk.UserGroupsZkRegistry;
import ru.yandex.inside.geobase.Geobase6;
import ru.yandex.inside.geobase.LinguisticsItem;
import ru.yandex.misc.io.ClassPathResourceInputStreamSource;

/**
 * @author tolmalev
 */
@Configuration
public class CoolLentaBlockGeneratorsContextConfiguration {

    @Bean
    public GeoNamesSource geoNamesSource(Geobase6 geobase) {
        if (geobase != null) {
            return (regionId, translationCase, language) -> {
                LinguisticsItem translations = geobase.getLinguisticsItemByRegionId(regionId, language.value())
                        .getOrThrow("No translations for region " + regionId);
                switch (translationCase) {
                    case DATIVE:
                        return translations.getDativeCase();
                    case ABLATIVE:
                        return translations.getAblativeCase();
                    case GENITIVE:
                        return translations.getGenitiveCase();
                    case LOCATIVE:
                        return translations.getLocativeCase();
                    case ACCUSATIVE:
                        return translations.getAccusativeCase();
                    case NOMINATIVE:
                        return translations.getNominativeCase();
                    case DIRECTIONAL:
                        return translations.getDirectionalCase();
                    case PREPOSITION:
                        return translations.getPreposition();
                    case INSTRUMENTAL:
                        return translations.getInstrumentalCase();
                    case PREPOSITIONAL:
                        return translations.getPrepositionalCase();
                    default:
                        throw new IllegalArgumentException("Unknown case " + translationCase);
                }
            };
        }
        return GeoNamesSource.EMPTY;
    }

    @Bean
    public BlockTitlesGenerator blockTitilesGenerator(GeoNamesSource geoNamesSource) {
        return new BlockTitlesGenerator(geoNamesSource);
    }

    @Bean
    public DefaultBlockGenerator defaultBlockGenerator() {
        return new DefaultBlockGenerator();
    }

    @Bean
    public BestOfYearBlockGenerator bestOfYearBlockGenerator() {
        return new BestOfYearBlockGenerator();
    }

    @Bean
    public ThematicBlocksGenerator thematicBlocksGenerator(ThemeDefinitionRegistry themeDefinitionRegistry,
            Cvi2tProcessor cvi2tProcessor, ExperimentMembersByOverrideManager experimentMembersByOverrideManager)
    {
        return new ThematicBlocksGenerator(themeDefinitionRegistry, cvi2tProcessor, experimentMembersByOverrideManager,
                5, 20, false);
    }

    @Bean
    public TankerTextGenerator tankerTextGenerator(GeoNamesSource geoNamesSource) {
        return new TankerTextGenerator(
                new ClassPathResourceInputStreamSource(TankerTextGenerator.class, "yadisk_backend.lenta.json"),
                new TextProcessor(geoNamesSource));
    }

    @Bean
    public ExperimentMembersByOverrideManager experimentMembersByOverrideManager(UaasOverrideController uaasOverrideController,
            UserGroupsZkRegistry userGroupsZkRegistry) {
        return new ExperimentMembersByOverrideManager(uaasOverrideController, userGroupsZkRegistry);
    }
}
