package ru.yandex.chemodan.app.lentaloader.cool.generator;

import org.joda.time.DateTime;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.lentaloader.cool.CoolLentaFileItem;
import ru.yandex.chemodan.app.lentaloader.cool.utils.IntervalType;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.random.Random2;

public class RandomBlockGenerator extends AbstractCoolLentaBlockGenerator {

    private final int count;

    public RandomBlockGenerator(int count) {
        this.count = count;
    }

    @Override
    public String generatorIdPrefix() {
        return "random";
    }

    @Override
    public boolean isAcceptableIntervalType(IntervalType intervalType) {
        return true;
    }

    @Override
    public ListF<BlockGeneratingResult> generateBlocksWithoutIntervalCheck(ListF<CoolLentaFileItem> items,
            Option<PassportUid> uidO) {
        int itemsCount = items.size();
        if (itemsCount == 0) {
            throw new IllegalArgumentException(String.format("No files for user uid=%s",
                    uidO.getOrThrow("No uid provided for random block generator")));
        }
        if (itemsCount <= count) {
            return Cf.list(new BlockGeneratingResult(Option.empty(), items));
        }
        int i = 0;
        ListF<Integer> itemsIndexes = Cf.arrayList();
        while (i < count) {
            int index = Random2.R.nextInt(itemsCount);
            if (itemsIndexes.containsTs(index)) {
                continue;
            }
            itemsIndexes.add(index);
            i++;
        }
        return Cf.list(new BlockGeneratingResult(Option.empty(), itemsIndexes.sorted().map(items::get)));
    }

    @Override
    public ListF<BlockGeneratingResult> generateBlocks(ListF<CoolLentaFileItem> items, Option<PassportUid> uidO) {
        return generateBlocksWithoutIntervalCheck(items, uidO)
                .filter(result -> isAcceptableIntervalType(BlockGeneratorUtils.getInterval(result.getItems())._1));
    }

    @Override
    public ListF<String> generateAllPossibleIds(IntervalType intervalType, DateTime intervalStart) {
        return Cf.list(generateBlockId(intervalType, intervalStart, Option.empty()));
    }

    @Override
    public int getMinSizeForBlock() {
        return 0;
    }
}
