package ru.yandex.chemodan.app.lentaloader.cool.generator;

import lombok.Data;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.lentaloader.cool.utils.TermDefinition;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@Data
@BenderBindAllFields
public class ThemeDefinition {

    private final String name;

    private final ListF<WordMatch> words;

    private final TermDefinition forms;

    private final boolean enabled;

    private final Option<Boolean> experimentalForGenerating;

    private final Option<Boolean> useCustomTitlesOnly;

    private final Option<Boolean> experimentalForReminding;

    private final Option<Double> minBeauty;

    public boolean isExperimentalForGenerating() {
        return experimentalForGenerating.getOrElse(Boolean.FALSE);
    }

    public boolean useCustomTitlesOnly() {
        return useCustomTitlesOnly.getOrElse(Boolean.FALSE);
    }

    public boolean isExperimentalForReminding() {
        return experimentalForReminding.getOrElse(Boolean.FALSE);
    }
}
