package ru.yandex.chemodan.app.lentaloader.cool.imageparser;

import java.util.Optional;

import org.junit.Rule;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.util.test.AbstractTest;
import ru.yandex.chemodan.util.test.HttpRecorderRule;
import ru.yandex.inside.passport.tvm2.AddServiceTicketInterceptor;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.TvmClientCredentials;
import ru.yandex.misc.io.http.HttpException;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author tolmalev
 */
@ContextConfiguration(
        classes = {
                ImageparserClientTest.Config.class,
                ImageparserMockConfiguration.class
        }
)
public class ImageparserClientTest extends AbstractTest {
    private static final Logger logger = LoggerFactory.getLogger(ImageparserClientTest.class);

    @Rule
    @Autowired
    public final HttpRecorderRule httpRecorderRule = null;

    @Autowired
    private ImageparserClient imageparserClient;

    @Test(expected = HttpException.class)
    @HttpRecorderRule.IgnoreHeaders({"X-Ya-Service-Ticket", "User-Agent"})
    public void parseInvalidFile() {
        imageparserClient.parseImage("320.yadisk:18097732.E1052615:191754357185981736561970398200");
    }

    @Test
    @HttpRecorderRule.IgnoreHeaders({"X-Ya-Service-Ticket", "User-Agent"})
    public void parseValidFile() {
        imageparserClient.parseImage("320.yadisk:3000077416.E1395403:2972595172187330115249508715303");
    }

    @Test
    @HttpRecorderRule.IgnoreHeaders({"X-Ya-Service-Ticket", "User-Agent"})
    public void parseValidFileFromAvatars() {
        imageparserClient.parseImage("ava:disk:69197:2a00000168c80721fb4f8df90290d7046680");
    }

    public static class Config {
        @Bean
        public HttpRecorderRule httpRecorderRule() {
            return HttpRecorderRule.builder().prefix(System.getProperty("user.home") + "/arcadia/disk/lenta/backend/src/test/resources/").build();
        }

        @Bean
        public ImageparserClient imageparserClient(
                @Value("${imageparser.host}") String imageparserUrl,
                @ImageparserContextConfiguration.Imageparser
                        HttpClientConfigurator imageparserHttpClientConfigurator)
        {
            Tvm2 tvm2 = new Tvm2(new TvmClientCredentials(2000139, "almal0YAZNd93OfflsttRQ"));
            tvm2.addDstClientIds(Cf.list(200));
            tvm2.start();

            imageparserHttpClientConfigurator.setAddServiceTicketInterceptor(Optional.of(new AddServiceTicketInterceptor(r -> tvm2.getServiceTicket(200))));
            return new ImageparserClientImpl(imageparserUrl, imageparserHttpClientConfigurator.configure());
        }
    }
}
