package ru.yandex.chemodan.app.lentaloader.cool.imageparser;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.ratelimiter.ClusteredRpsLimiter;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author tolmalev
 */
@Configuration
public class ImageparserContextConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ImageparserContextConfiguration.class);

    @Value("${imageparser.max-total-rps}")
    private int maxRps;

    @Autowired(required = false)
    private Tvm2 tvm2;

    @Autowired
    private DynamicPropertyManager dynamicPropertyManager;

    @Qualifier
    @Retention(RetentionPolicy.RUNTIME)
    public @interface Imageparser {
    }

    @Bean
    public ImageparserClientImpl imageparserClientImpl(@Value("${imageparser.host}") String imageparserUrl) {
        return new ImageparserClientImpl(imageparserUrl, imageparserHttpClientConfigurator().configure());
    }

    @Bean
    @Primary
    public ImageparserClient imageparserClient(ImageparserClientImpl imageparserClientImpl) {
        if (EnvironmentType.getActive() != EnvironmentType.TESTS
                && EnvironmentType.getActive() != EnvironmentType.DEVELOPMENT
                && tvm2 == null)
        {
            throw new IllegalStateException("imageparser client needs configured TVM");
        }
        return imageparserRpsLimiter().wrapLimited(imageparserClientImpl, ImageparserClient.class);
    }

    @Bean
    public ClusteredRpsLimiter imageparserRpsLimiter() {
        return new ClusteredRpsLimiter("cool-lenta-imageparser", maxRps, dynamicPropertyManager);
    }

    @Bean
    @Imageparser
    @OverridableValuePrefix("imageparser")
    public HttpClientConfigurator imageparserHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }
}
