package ru.yandex.chemodan.app.lentaloader.cool.imageparser;

import org.apache.http.client.config.RequestConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.util.test.HttpRecorderRule;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;

/**
 * @author tolmalev
 */
@ContextConfiguration
public class ImageparserMockConfiguration {

    @Bean
    @OverridableValuePrefix("imageparser")
    @ImageparserContextConfiguration.Imageparser
    public HttpClientConfigurator imageparserHttpClientConfigurator(HttpRecorderRule rule) {
        return new HttpClientConfigurator() {
            @Override
            public ApacheHttpClientUtils.Builder createBuilder() {
                return super.createBuilder().withRequestConfig(RequestConfig.custom().setProxy(rule.getHost()).build()).withRequestRetry();
            }
        };
    }
}
