package ru.yandex.chemodan.app.lentaloader.cool.log;

import lombok.AllArgsConstructor;
import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.lentaloader.cool.model.CoolLentaModelUtils;
import ru.yandex.chemodan.app.lentaloader.cool.model.MinimalCoolLentaBlock;
import ru.yandex.chemodan.app.lentaloader.cool.model.MinimalCoolLentaMordaBlock;
import ru.yandex.chemodan.app.lentaloader.log.LentaEventLogger;
import ru.yandex.chemodan.app.lentaloader.log.LogDataProvider;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.enums.EnumUtils;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@Data
@AllArgsConstructor
public class CoolLentaBlockEvent extends DefaultObject implements LogDataProvider {
    public final PassportUid uid;
    public final CoolLentaEventType eventType;
    public final MinimalCoolLentaBlock block;
    public final Option<Long> revision;

    public CoolLentaBlockEvent(PassportUid uid, CoolLentaEventType eventType, MinimalCoolLentaBlock block) {
        this(uid, eventType, block, Option.empty());
    }

    @Override
    public Tuple2List<String, String> logData() {
        Tuple2List<String, String> result = Tuple2List.arrayList();

        result.add("uid", uid.toString());
        result.add("event_type", EnumUtils.toXmlName(eventType));

        result.add("block_id", block.id);

        ListF<Tuple2<String, DataField>> fields;
        if (block instanceof MinimalCoolLentaMordaBlock) {
            fields = CoolLentaModelUtils.getDataFieldsForMorda((MinimalCoolLentaMordaBlock) block);
            result.add("block_collection", "morda_blocks");
        } else {
            fields = CoolLentaModelUtils.blockDataFields(block);
            result.add("block_collection", "all_blocks");
        }

        result.add("block", LentaEventLogger.serializeToJson(Cf.toMap(fields)));
        revision.forEach(r -> result.add("revision", Long.toString(r)));

        return result;
    }

    public CoolLentaBlockEvent withRevision(long rev) {
        return new CoolLentaBlockEvent(uid, eventType, block, Option.of(rev));
    }
}
