package ru.yandex.chemodan.app.lentaloader.cool.model;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.inside.utils.ConstLocalizedString;
import ru.yandex.inside.utils.DynamicLocalizedString;
import ru.yandex.inside.utils.Language;
import ru.yandex.inside.utils.LocalizedString;
import ru.yandex.misc.bender.PartPosition;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.RootLevelUnmarshaller;
import ru.yandex.misc.bender.parse.UnmarshallerContext;
import ru.yandex.misc.bender.parse.XmlOrJsonNode;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToParentObjectMarshaller;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author tolmalev
 */
public class LocalizedStringMarshallerUnmarshaller implements ToParentObjectMarshaller, RootLevelUnmarshaller {
    private static final MapF<String, Language> LANG_BY_SHORT =
            Cf.x(Language.values()).toMapMappingToKey(Language::value);

    @Override
    public ParseResult<Object> parseO(XmlOrJsonNode node, PartPosition pp, UnmarshallerContext context) {
        final Tuple2List<XmlOrJsonNode, XmlOrJsonNode> nodes;
        if (!node.isJson()) {
            throw new UnsupportedOperationException("xml not supported");
        }
        BenderJsonNode json = node.getJson();

        if (pp instanceof PartPosition.Ordinary) {
            PartPosition.Ordinary ordinary = (PartPosition.Ordinary) pp;
            String fieldName = ordinary.getWrapperName().getOrElse(ordinary.getName()).getLocalPartJson();
            Option<BenderJsonNode> fieldO = node.getJson().getField(fieldName);

            if(!fieldO.isPresent()) {
                return ParseResult.failure("Field not found: " + pp);
            }

            json = fieldO.get();
        }

        if (json.isString()) {
            return ParseResult.result(new ConstLocalizedString(json.getString()));
        } else if (json.isObject()) {
            MapF<Language, String> languages = Cf.hashMap();
            for (String field : json.getFieldNames()) {
                BenderJsonNode finalJson = json;
                LANG_BY_SHORT.getO(field).forEach(
                        lang -> languages.put(lang, finalJson.getField(field).get().getValueAsString()));
            }

            return ParseResult.result(new DynamicLocalizedString(languages));

        } else {
            return ParseResult.failure("Cant parse node: " + json);
        }
    }

    @Override
    public void writeXmlToParentObject(XmlWriter writer, Object o, PartPosition pp, MarshallerContext context) {
        throw new UnsupportedOperationException("xml not supported");
    }

    @Override
    public void writeJsonToParentArray(BenderJsonWriter writer, Object o, MarshallerContext context) {
        LocalizedString localized = (LocalizedString) o;

        if (localized instanceof ConstLocalizedString) {
            writer.writeString(localized.get(Language.RUSSIAN));
            return;
        }

        writer.writeObjectStart();
        for (Language language : Language.values()) {
            localized.getO(language).forEach(value -> {
                writer.writeFieldName(language.value());
                writer.writeString(value);
            });
        }
        writer.writeObjectEnd();

    }

    @Override
    public void writeJsonToParentObject(BenderJsonWriter writer, Object o, PartPosition.Ordinary ordinary,
            MarshallerContext context)
    {
        String fieldName = ordinary.getWrapperName().getOrElse(ordinary.getName()).getLocalPartJson();
        writer.writeFieldName(fieldName);

        writeJsonToParentArray(writer, o, context);
    }
}
