package ru.yandex.chemodan.app.lentaloader.cool.model;

import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.mpfs.MpfsResourceId;

/**
 * @author tolmalev
 */
@Data
public class MinimalCoolLentaMordaBlock extends MinimalCoolLentaBlock {
    public final Instant mtime;
    public final String allBlocksId;

    public MinimalCoolLentaMordaBlock(String id, String generationType, String allBlocksId, ListF<MpfsResourceId> resourceIds,
                                      MpfsResourceId bestResourceId, String userTimezoneId,
                                      Option<Instant> photosliceDate, Instant minDate, Instant maxDate, Instant mtime,
                                      Option<Instant> lastShowDate, Option<Instant> legacyLentaLastShowDate,
            Option<Instant> legacyLentaLastPushDate, boolean pushSent)
    {
        super(id, generationType, resourceIds, bestResourceId, userTimezoneId, photosliceDate, minDate, maxDate, lastShowDate,
                legacyLentaLastShowDate, legacyLentaLastPushDate, pushSent);
        this.allBlocksId = allBlocksId;
        this.mtime = mtime;
    }
}
