package ru.yandex.chemodan.app.lentaloader.cool.worker;

import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.lentaloader.cool.CoolLentaManager;
import ru.yandex.chemodan.app.lentaloader.worker.LentaTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
public class CheckAndDeleteInvalidBlock extends OnetimeTaskSupport<CheckAndDeleteInvalidBlock.Parameters> {
    private final CoolLentaManager coolLentaManager;

    public CheckAndDeleteInvalidBlock(CoolLentaManager coolLentaManager) {
        super(Parameters.class);
        this.coolLentaManager = coolLentaManager;
    }

    public CheckAndDeleteInvalidBlock(PassportUid uid, String blockId) {
        super(new Parameters(uid, blockId));
        this.coolLentaManager = null;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        coolLentaManager.checkInvalidBlock(parameters.uid, parameters.blockId);
    }

    @Override
    public int priority() {
        return 30;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @Override
    public TaskQueueName queueName() {
        return LentaTaskQueueName.LENTA_COOL;
    }

    @Data
    @BenderBindAllFields
    public static class Parameters extends DefaultObject {
        public final PassportUid uid;
        public final String blockId;
    }
}
