package ru.yandex.chemodan.app.lentaloader.cool.worker;

import java.util.concurrent.TimeUnit;

import net.jodah.failsafe.RetryPolicy;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.lentaloader.LentaYtContextConfiguration;
import ru.yandex.chemodan.app.lentaloader.YtPathsUtils;
import ru.yandex.chemodan.app.lentaloader.cool.CoolLentaManager;
import ru.yandex.chemodan.app.lentaloader.memories.CollectUsersWithBlocksDataCronTask;
import ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchClient;
import ru.yandex.chemodan.util.blackbox.UserTimezoneHelper;
import ru.yandex.chemodan.util.yt.YqlHelper;
import ru.yandex.chemodan.util.yt.YtHelper;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.bazinga.pg.storage.PgBazingaStorage;
import ru.yandex.inside.yt.kosher.Yt;

/**
 * @author tolmalev
 */
@Configuration
@Import({LentaYtContextConfiguration.class})
public class CoolLentaWorkerContextConfiguration {

    @Value("${cool-lenta.yt.operation.retry.count}")
    private int ytOperationRetryCount;

    @Value("${cool-lenta.memories.yt.operation.retry.delay}")
    private Duration ytOperationRetryDelay;

    @Bean
    public ProcessImagesChangesCronTask processImagesChangesCronTask(CoolLentaRoutines coolLentaRoutines) {
        return new ProcessImagesChangesCronTask(coolLentaRoutines);
    }

    @Bean
    public CoolLentaRoutines coolLentaRoutines(
            UserTimezoneHelper userTimezoneHelper,
            BazingaTaskManager bazingaTaskManager,
            @Value("${cool-lenta.yt.schedule-batch-size}")
            int scheduleBatchSize, YtHelper coolLentaYtHelper, YqlHelper yqlHelper)
    {
        return new CoolLentaRoutines(coolLentaYtHelper, yqlHelper, userTimezoneHelper, bazingaTaskManager,
                YtPathsUtils.getCoolLentaYPath(), scheduleBatchSize);
    }

    @Bean
    public YtHelper coolLentaYtHelper(Yt ytClient, RetryPolicy ytCoolLentaRetryPolicy) {
        return new YtHelper(ytClient, ytCoolLentaRetryPolicy);
    }

    @Bean
    public ScheduleUserBlocksGenerationCron scheduleUserBlocksGenerationCron(
            CoolLentaTasksScheduler tasksScheduler,
            PgBazingaStorage pgBazingaStorage,
            @Value("${cool-lenta.reindex.scheduler.threads}")
            int scheduleBatchSize, YtHelper coolLentaYtHelper)
    {
        return new ScheduleUserBlocksGenerationCron(tasksScheduler, YtPathsUtils.getCoolLentaReindexQueueYPath(), coolLentaYtHelper,
                pgBazingaStorage, scheduleBatchSize);
    }

    @Bean
    public ScheduleProcessOneDayTask scheduleProcessOneDayTask(CoolLentaRoutines coolLentaRoutines) {
        return new ScheduleProcessOneDayTask(coolLentaRoutines);
    }

    @Bean
    public ScheduleOldIntervalGeneration scheduleOldIntervalGeneration(CoolLentaRoutines coolLentaRoutines) {
        return new ScheduleOldIntervalGeneration(coolLentaRoutines);
    }

    @Bean
    public ScheduleOldIntervalsCron scheduleOldIntervalsCron(CoolLentaRoutines coolLentaRoutines) {
        return new ScheduleOldIntervalsCron(coolLentaRoutines);
    }

    @Bean
    public ScheduleProcessingForUserTask scheduleProcessingForUserTask(CoolLentaTasksScheduler coolLentaTasksScheduler) {
        return new ScheduleProcessingForUserTask(coolLentaTasksScheduler);
    }

    @Bean
    public ProcessOneIntervalTask processOneInterval(CoolLentaManager manager) {
        return new ProcessOneIntervalTask(manager);
    }

    @Bean
    public ProcessOneIntervalHighPriorityTask processOneIntervalHighPriorityTask(CoolLentaManager manager) {
        return new ProcessOneIntervalHighPriorityTask(manager);
    }

    @Bean
    public ProcessOneIntervalLowPriorityTask processOneIntervalLowPriorityTask(CoolLentaManager manager) {
        return new ProcessOneIntervalLowPriorityTask(manager);
    }

    @Bean
    public ProcessOneFutureIntervalTask processOneFutureIntervalTask(BazingaTaskManager bazingaTaskManager) {
        return new ProcessOneFutureIntervalTask(bazingaTaskManager);
    }

    @Bean
    public CollectUsersWithBlocksDataCronTask collectUsersWithBlocksDataCronTask(YtHelper coolLentaYtHelper, YqlHelper yqlHelper,
            @Value("${lenta-worker.users-with-blocks.task.execution-hour}") int executionHour,
            @Value("${lenta-worker.users-with-blocks.task.retry-count}") int retryCount,
            @Value("${lenta-worker.users-with-blocks.task.wait-for-source.duration.minutes}") int waitForSourceDataDurationMinutes)
    {
        return new CollectUsersWithBlocksDataCronTask(coolLentaYtHelper, yqlHelper, executionHour, retryCount,
                waitForSourceDataDurationMinutes);
    }

    @Bean
    public CoolLentaTasksScheduler coolLentaTasksScheduler(BazingaTaskManager bazingaTaskManager,
            DiskSearchClient diskSearchClient, UserTimezoneHelper userTimezoneHelper)
    {
        return new CoolLentaTasksScheduler(bazingaTaskManager, diskSearchClient, userTimezoneHelper);
    }

    @Bean
    public CheckAndDeleteInvalidBlock checkAndDeleteInvalidBlock(CoolLentaManager coolLentaManager) {
        return new CheckAndDeleteInvalidBlock(coolLentaManager);
    }

    @Bean
    public BuildCurrentCoolLentaSnapshotCron buildCurrentCoolLentaSnapshotCron(CoolLentaRoutines coolLentaRoutines) {
        return new BuildCurrentCoolLentaSnapshotCron(coolLentaRoutines);
    }

    @Bean
    public CleanOldCoolLentaTablesCron cleanOldCoolLentaTablesCron(CoolLentaRoutines coolLentaRoutines) {
        return new CleanOldCoolLentaTablesCron(coolLentaRoutines);
    }

    @Bean
    protected RetryPolicy ytCoolLentaRetryPolicy() {
        return new RetryPolicy()
                .withMaxRetries(ytOperationRetryCount)
                .withDelay(ytOperationRetryDelay.getMillis(), TimeUnit.MILLISECONDS);
    }
}
