package ru.yandex.chemodan.app.lentaloader.cool.worker;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.lentaloader.worker.LentaTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleWithRetry;
import ru.yandex.misc.time.MoscowTime;

/**
 * @author tolmalev
 */
public class ProcessImagesChangesCronTask extends CronTask {
    private final CoolLentaRoutines coolLentaRoutines;

    public ProcessImagesChangesCronTask(CoolLentaRoutines coolLentaRoutines) {
        this.coolLentaRoutines = coolLentaRoutines;
    }

    @Override
    public Schedule cronExpression() {
        return new ScheduleWithRetry(new ScheduleCron("0 4 * * *", MoscowTime.TZ), 24);
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(1);
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        coolLentaRoutines.processYesterdayChanges();
    }

    @Override
    public TaskQueueName queueName() {
        return LentaTaskQueueName.LENTA_CRON;
    }
}
