package ru.yandex.chemodan.app.lentaloader.cool.worker;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.lentaloader.cool.utils.IntervalType;
import ru.yandex.chemodan.app.lentaloader.worker.LentaTaskQueueName;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author tolmalev
 */
public class ProcessOneFutureIntervalTask extends OnetimeTaskSupport<ProcessOneIntervalTask.Parameters> {
    private final BazingaTaskManager bazingaTaskManager;

    public ProcessOneFutureIntervalTask(ProcessOneIntervalTask.Parameters parameters) {
        super(parameters);
        this.bazingaTaskManager = null;
    }

    public ProcessOneFutureIntervalTask(PassportUid uid, Instant time, IntervalType type) {
        this(new ProcessOneIntervalTask.Parameters(uid, time, type));
    }

    protected ProcessOneFutureIntervalTask(BazingaTaskManager bazingaTaskManager) {
        super(ProcessOneIntervalTask.Parameters.class);
        this.bazingaTaskManager = bazingaTaskManager;
    }

    @Override
    protected void execute(ProcessOneIntervalTask.Parameters parameters, ExecutionContext context) throws Exception {
        bazingaTaskManager.schedule(new ProcessOneIntervalTask(parameters));
    }

    @Override
    public int priority() {
        // Приоритет выше чем у ProcessOneIntervalTask
        // Это сделано специально чтобы видеть в очереди тасков ProcessOneIntervalTask реальную куартину того, что надо бы уже обработать
        return 60;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(1);
    }

    @Override
    public TaskQueueName queueName() {
        return LentaTaskQueueName.LENTA_COOL;
    }
}
