package ru.yandex.chemodan.app.lentaloader.cool.worker;

import lombok.Data;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.lentaloader.cool.CoolLentaManager;
import ru.yandex.chemodan.app.lentaloader.cool.utils.IntervalType;
import ru.yandex.chemodan.app.lentaloader.worker.LentaTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
public class ProcessOneIntervalTask extends OnetimeTaskSupport<ProcessOneIntervalTask.Parameters> {
    private final CoolLentaManager coolLentaManager;

    public ProcessOneIntervalTask(Parameters parameters) {
        super(parameters);
        this.coolLentaManager = null;
    }

    public ProcessOneIntervalTask(PassportUid uid, Instant time, IntervalType type) {
        this(new Parameters(uid, time, type));
    }

    protected ProcessOneIntervalTask(CoolLentaManager coolLentaManager) {
        super(Parameters.class);
        this.coolLentaManager = coolLentaManager;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        coolLentaManager.process(parameters.uid, parameters.time, parameters.type);
    }

    @Override
    public int priority() {
        return 50;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(10);
    }

    @Override
    public TaskQueueName queueName() {
        return LentaTaskQueueName.LENTA_COOL;
    }

    @BenderBindAllFields
    @Data
    public static class Parameters {
        public final PassportUid uid;
        public final Instant time;
        public final IntervalType type;
    }
}
