package ru.yandex.chemodan.app.lentaloader.cool.worker;

import lombok.Data;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.lentaloader.cool.utils.IntervalType;
import ru.yandex.chemodan.app.lentaloader.worker.LentaTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
public class ScheduleOldIntervalGeneration extends OnetimeTaskSupport<ScheduleOldIntervalGeneration.Parameters> {
    private final CoolLentaRoutines coolLentaRoutines;

    public ScheduleOldIntervalGeneration(CoolLentaRoutines coolLentaRoutines) {
        super(Parameters.class);
        this.coolLentaRoutines = coolLentaRoutines;
    }

    public ScheduleOldIntervalGeneration(IntervalType type, Instant timeInInterval) {
        super(new Parameters(type, timeInInterval));
        this.coolLentaRoutines = null;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        coolLentaRoutines.scheduleOldIntervalGeneration(parameters.intervalType, parameters.timeInInterval);
    }

    @Override
    public int priority() {
        return 60;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(4);
    }

    @Override
    public TaskQueueName queueName() {
        return LentaTaskQueueName.LENTA_COOL_SCHEDULE;
    }

    @BenderBindAllFields
    @Data
    public static class Parameters extends DefaultObject {
        public final IntervalType intervalType;
        public final Instant timeInInterval;
    }
}
