package ru.yandex.chemodan.app.lentaloader.cool.worker;

import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.lentaloader.cool.utils.IntervalType;
import ru.yandex.chemodan.app.lentaloader.worker.LentaTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
public class ScheduleProcessOneDayTask extends OnetimeTaskSupport<ScheduleProcessOneDayTask.Parameters> {
    private final CoolLentaRoutines coolLentaRoutines;

    public ScheduleProcessOneDayTask(CoolLentaRoutines coolLentaRoutines) {
        super(Parameters.class);
        this.coolLentaRoutines = coolLentaRoutines;
    }

    public ScheduleProcessOneDayTask(YPath path, long lowerRowIndex, long upperRowIndex, IntervalType intervalType) {
        super(new Parameters(path.toString(), lowerRowIndex, upperRowIndex, Option.of(intervalType)));
        this.coolLentaRoutines = null;
    }

    public ScheduleProcessOneDayTask(YPath path, long lowerRowIndex, long upperRowIndex) {
        super(new Parameters(path.toString(), lowerRowIndex, upperRowIndex, Option.empty()));
        this.coolLentaRoutines = null;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        YPath pathWithRange = YPath.simple(parameters.ytPath).withRange(parameters.lowerRowIndex, parameters.upperRowIndex);
        coolLentaRoutines.scheduleProcessOneDayTasks(pathWithRange, parameters.intervalType);
    }

    @Override
    public int priority() {
        return 70;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(10);
    }

    @Override
    public TaskQueueName queueName() {
        return LentaTaskQueueName.LENTA_COOL_SCHEDULE;
    }

    @BenderBindAllFields
    @Data
    public static class Parameters extends DefaultObject {
        public final String ytPath;
        public final long lowerRowIndex;
        public final long upperRowIndex;

        public final Option<IntervalType> intervalType;
    }
}
