package ru.yandex.chemodan.app.lentaloader.cool.worker;

import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.lentaloader.worker.LentaTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
public class ScheduleProcessingForUserTask extends OnetimeTaskSupport<ScheduleProcessingForUserTask.Parameters> {
    private final CoolLentaTasksScheduler scheduler;

    public ScheduleProcessingForUserTask(CoolLentaTasksScheduler scheduler) {
        super(Parameters.class);
        this.scheduler = scheduler;
    }

    public ScheduleProcessingForUserTask(PassportUid uid) {
        super(new Parameters(uid));
        this.scheduler = null;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        scheduler.scheduleTasksForUser(parameters.uid);
    }

    @Override
    public int priority() {
        return 50;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(10);
    }

    @Override
    public TaskQueueName queueName() {
        return LentaTaskQueueName.LENTA_COOL_SCHEDULE;
    }

    @BenderBindAllFields
    @Data
    public static class Parameters {
        public final PassportUid uid;
    }
}
